############################ Random Variables ###########################

################################################# set 'working Directory'
setwd("D:/AS17 translation/AS17 supplements")
opar <- par() 
#options(warn=-1)
#########################################################################

                                                          # Section 5.1.1
                                                        
                                                             # figure 5.2  
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=12)
x <- seq(1, 6, by=1); fx <- rep(1/6, 6)
plot(x, fx, type="h", ylim=c(0, 0.2), ylab="f(x)", las=1, lty=2,
     cex.lab=1.3, xlab="Number of eyes", col="grey")
points(x, fx, pch=19, cex=1.4, col="black")
F <- cumsum(fx)
x1 <- c(0, x, 7)
Fx <- c(0, F, 1)
plot(x1, Fx, type="s", ylim=c(0, 1), ylab="F(x)", las=1,
     cex.lab=1.3, xlab="Number of eyes")

#########################################################################

                                                             # figure 5.3  
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=12)
x <- seq(2, 12, by=1)
fx <- c(1/36, 2/36, 3/36, 4/36, 5/36, 6/36, 5/36, 4/36, 3/36, 2/36, 1/36)
plot(x, fx, type="h", ylim=c(0, 0.2), ylab="f(x)", las=1, lty=2,
     cex.lab=1.3, xlab="Number of eyes", col="grey")
points(x, fx, pch=19, cex=1.4, col="black")
F <- cumsum(fx)
x1 <- c(0, x, 13)
Fx <- c(0, F, 1)
plot(x1, Fx, type="s", ylim=c(0,   1), ylab="F(x)", las=1, 
     cex.lab=1.3, xlab="Number of eyes")

#########################################################################

                                                             # figure 5.5
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=13)
m   <- 10;  s   <- 3 
x   <- seq(m-3*s, m+3*s, by=0.1)
y0  <- dnorm(x, mean=m, sd=s)
y1  <- y0*1.4; y2  <- y0*0.4

plot (x, y0, type="l", las=1,
      ylim=c(0, 0.2), xlim=c(0, 20), ylab=" ", xlab=" ")
lines(x, y1)
lines(x, y2)
text(13.0, 0.18, "steep")
text(14.5, 0.12, "normal")
text(10, 0.07, "flat")

plot (x, y0, type="l", las=1,
      ylim=c(0, 0.2), xlim=c(0,20), ylab=" ",lty=2, xlab=" ")
y3 <- dlnorm(x, meanlog=1.7, sdlog=0.5)
lines(x, y3)
lines(sort(x, decreasing = TRUE), y3)
text(3, 0.18, "skewed to right")
text(17, 0.18, "skewed to left")

#########################################################################

                                                          # Section 5.2.3
                                                        
x <- c(2, 3, 4, 4, 4, 5, 5, 5, 5, 6, 8, 10, 20, 40)                                                     
m <- mean(x); s <- sd(x); n <- length(x)
(1/n)*sum((x-m)^3)/(s^3)
(1/n)*sum((x-m)^4)/(s^4) - 3

library(e1071)
skewness(x, type = 3)                                          # skewness

kurtosis(x, type = 3)                                          # kutosis       

#########################################################################

                                                          # power moments
moments <- function(x, f, d, b) {       # x data
                                        # f frequencies (classes)
                                        # d origin (mode, reference)
                                        # b class width
    n <- sum(f);     z <- (x - d) / b
    m1 <- sum(f * z) / n;      m2 <- sum(f * z^2) / n
    m3 <- sum(f * z^3) / n;    m4 <- sum(f * z^4) / n
    s2 <- b^2 * (m2 - m1^2);   s3 <- (sqrt(s2))^3;     s4 <- s2^2
    mitt <- d + (b * m1)
    vari <- b^2 * (m2 - m1^2)
    schi <- (b^3 * (m3 - 3*m1*m2 + 2*m1^3)) / s3
    woel <- ((b^4 * (m4 - 4*m1*m3 + 6*m1^2*m2 - 3*m1^4)) / s4) - 3
    cat("\n","Moments from classified observations:","\n",
        "    Mean:",mitt,"\n",        "Variance:",vari,"\n",
        "Skewness:",schi,"\n",        "Kurtosis:",woel,"\n")
} 
x <- c(8.8, 9.3, 9.8, 10.3, 10.8, 11.3, 11.8)                # table 5.1
f <- c(  4,   8,  11,    7,    5,    3,    2)
d <- 9.8;   b <- 0.5

moments(x, f, d, b)                                                

#########################################################################

                                           # different distribution form

b      <- 10                                   # class width
d      <- 30                                   # origin
x      <- c(15, 25, 35, 45, 55, 65, 75, 85)    # class mids
f1     <- c( 5, 10, 15, 30, 30, 15, 10,  5)    # frequencies
f2     <- c(20, 30, 30, 20, 10,  5,  5,  0)
f3     <- c( 0,  5,  5, 10, 20, 30, 30, 20)
f4     <- c( 5, 15, 30, 10, 10, 30, 15,  5)

par(mfrow=c(2,2), lwd=2, font.axis=2, bty="n", ps=13)
moments(x, f1, d, b); barplot(f1, width=b, space=0, names.arg=x)
moments(x, f2, d, b); barplot(f2, width=b, space=0, names.arg=x)
moments(x, f3, d, b); barplot(f3, width=b, space=0, names.arg=x)
moments(x, f4, d, b); barplot(f4, width=b, space=0, names.arg=x)

#########################################################################

library(e1071)
x1 <- c(rep(8.8,4), rep(9.3,8), rep(9.8,11), rep(10.3,7), rep(10.8,5),
        rep(11.3,3), rep(11.8, 2))
mean(x1); var(x1); skewness(x1); kurtosis(x1)

#########################################################################

                                                             # figure 5.6  
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=18)
hist(x1, breaks=c(seq(8.55, 12.05, by=0.5)), freq=TRUE, col="grey",las=1,
     ylim=c(0, 12), xlim=c(8, 13), xlab=" ", main=" ", ylab="Frequency")

#########################################################################

                                                        # Section 5.2.3.3

                                              # body heigh of 70 students
y <- c(63, 63, 64, 64, rep(65,4), rep(66,5), rep(67,4), 
       rep(68,6), rep(69,5), rep(70,8), rep(71,7), rep(72,7), 
       rep(73,10), rep(74,5), rep(75,3), rep(76,2))
                                                             # figure 5.7  
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=18)
hist(y, breaks=c(seq(62, 76, by=2)), freq=TRUE, col="grey", las=1,
     ylim=c(0, 15), xlim=c(62, 76), xlab=" ", main=" ", ylab="Frequency")

#########################################################################

mean(y)                                     # mean                            
var(y)                                      # empirical variance                    
skewness(y)                                 # empirical 3rd moment               
kurtosis(y)                                 # empirical 4th moment 
                                            # quartiles
Q    <- quantile(y, probs=seq(0, 1, 0.25), names=TRUE, type=7); Q    
Q1   <- as.numeric(Q[2]); Q2 <- as.numeric(Q[3]); Q3 <- as.numeric(Q[4])
skew <- (Q3 + Q1 - 2*Q2)/(Q3-Q1);  skew
                                            # oktiles  
A    <- quantile(y, probs=seq(0, 1, 0.125), names=TRUE, type=7); A  
A7 <- as.numeric(A[8]); A6 <- as.numeric(A[7]); A5 <- as.numeric(A[6])
A3 <- as.numeric(A[4]); A2 <- as.numeric(A[3]); A1 <- as.numeric(A[2])
kurt <- ((A7 - A5) + (A3 - A1))/(A6-A2); kurt
                                            
fivenum(y)                                         # Tukey's five numbers

#########################################################################

                                                          # Section 5.3.2

                                          # discrete uniform distribution 
library(e1071)
ddiscrete(1:10, rep(0.1, 10))                     # density function             
pdiscrete(1:10, rep(0.1, 10))                     # distribution function        
qdiscrete(c(0.25, 0.5, 0.75), rep(0.1, 10))       # quantile function 
rdiscrete(20, 1:10)                               # random numbers              

                                                             # figure 5.8  
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
x  <- 1:10; fx <- ddiscrete(1:10, rep(0.1, 10))    
plot(x, fx, type="h", las=1, ylim=c(0, 0.12), xlim=c(0,12), 
     ylab="f(x)", xlab=" ", lty=2, col="grey")
points(x, fx, pch=19, cex=1.1, col="black")

Fx <- pdiscrete(1:10, rep(0.1, 10)) 
x1 <- c(0, x, 11, 12); Fx <- c(0, Fx, 1, 1)
plot(x1, Fx, type="s", las=1, ylim=c(0,1), xlim=c(0,12), 
     ylab="F(x)", xlab=" ")

#########################################################################

                                                          # Section 5.3.3
                                                     
n <- 100                                                # Bernoulli trial
x <- sample(c(-1,1), n, replace=T, prob=c(0.6,0.4))
                                                             # figure 5.9
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, type="h", axes=FALSE, xlab="Bernoulli trials", ylab="Outcome")
axis(1, at = NULL, labels = TRUE, tick = TRUE)
text(0, -0.5, "A");  text(0, +0.5, "B")

#########################################################################

                                                        # Section 5.3.3.2
                                                      
                                                  # binomial distribution

                                                            # figure 5.10 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
n  <- 4; p  <- 1/6; x  <- 0:n; fx <- dbinom(x, n, p)    
plot(x, fx, type="h", ylim=c(0, 0.5), xlim=c(0,n), ylab="f(x)", 
            xlab=" ", lty=2, col="grey", las=1)
points(x, fx, pch=19, cex=1.1, col="black")

Fx <- pbinom(x, n, p); x1 <- c(x, n+1, n+2); Fx <- c(Fx, 1, 1)
plot(x1, Fx, type="s", ylim=c(0,1), xlim=c(0,n+2), las=1,
     ylab="F(x)", xlab=" ")
lines(c(0,0),c(0,Fx[1]))

#########################################################################

dbinom(3, 3, 1/2)
dbinom(2, 3, 1/2)

#########################################################################

                                                              # table 5.2 
prob <- c(0.01, 0.05, 0.10, 0.20, 0.25, 0.30, 0.40, 0.50)
tab  <- matrix(data = NA, nrow = 18, ncol = 8, byrow = FALSE, 
            dimnames = NULL)
row  <- 1
for (n in 2:5) { 
    for (i in 0:n) {
        tab[row, ] <- round(dbinom(i, n, prob), 4)
        row <- row +1  }  }
tab       

#########################################################################
                                             
dbinom(0, 4, 0.2)                            # example rejecting pencils
dbinom(1, 4, 0.2)
dbinom(2, 4, 0.2)

dbinom(0:4, 4, 0.2)
pbinom(2, 4, 0.2)
                                         
1 - pbinom(0, 6, 1/6, lower.tail=TRUE)       # example Chevalier de Mere
pbinom(1, 12, 1/6, lower.tail=FALSE)
                                          
pbinom(18, 120, 1/6)                         # example throwing a dice
                                      
round(200*dbinom(0:4, 4, 0.465),  2)         # example mouse litters
                                            
dbinom(1, 2, 0.8)                            # example treatment successes
dbinom(1, 5, 0.8)
dbinom(5, 5, 0.8)
                                            
dbinom(2, 5, 0.5)                            # example five children
dbinom(5, 5, 0.5)

#########################################################################

                                                        # Section 5.3.3.3
                                                                
                           # approximationen of the binomial distribuion 
p <- c(0.05, 0.5); q <- 1-p
n <- c(100,   10)
X <- c(10,     8)
                                                        
P0 <- 1 - pbinom(X, n, p, lower.tail = TRUE)             # exact binomial  

m <- n*p; s <- sqrt(n*p*(1-p))
Z1 <- (X + 0.5 - m) / s                                  # normal
P1 <- 1 - pnorm(Z1)

Z2 <- (asin(sqrt(X/n)) - asin(sqrt(p))) / sqrt(1/(4*n))  # arcsin 
P2 <- 1 - pnorm(Z2)

Z3 <- 2*(asin(sqrt((X+1)/(n+1)))-asin(sqrt(p))) * sqrt(n+0.5)  # Freeman
P3 <- 1 - pnorm(Z3)

Z4 <- (sqrt(4*q*(X+1)) - sqrt(4*p*(n-X)))              # Mosteller-Tukey 
P4 <- 1 - pnorm(Z4)

Z5 <- (sqrt(q*(4*X+3)) - sqrt(p*(4*n-4*X-1)))          # Freeman-Tukey   
P5 <- 1 - pnorm(Z5)

#########################################################################

tab <- cbind(P0, P1, P2, P3, P4, P5); round(tab, 4)           # table 5.3     

#########################################################################

                                                 # arc sin transformation

p.1 <- seq(0.0, 0.9, by=0.1)                                  # table 5.4     
p.2 <- seq(0, 0.09, by=0.01)
p   <- matrix(rep(NA, 100), nrow=10, ncol=10)
for (i in 1:10) {for (k in 1:10) {p[i,k] <- p.1[i] + p.2[k]}}
z   <- round(asin(sqrt(p))*(180/pi), 3)
tab <- cbind(p.1, z); tab

#########################################################################

                                                          # Section 5.3.4

n <- 4; p=c(0.4, 0.3, 0.3)                     # multinomial distribution
M <- matrix(c(0,0,4, 0,1,3, 0,2,2, 0,3,1, 0,4,0, 1,0,3, 1,1,2, 1,2,1, 
              1,3,0, 2,0,2, 2,1,1, 2,2,0, 3,0,1, 3,1,0, 4,0,0),
              byrow=FALSE, nrow=3);  
P <- rep(NA, 15); for (i in 1:15) P[i] <- dmultinom(M[,i], prob=p)
round(P, 3)
                                                          
library(scatterplot3d)                                      # figure 5.11 
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
z <- P; x <- M[1,]; y <- M[2,]
scatterplot3d(x, y, z, col.axis="black", type="h", highlight.3d=TRUE,
      box=FALSE, col.grid="grey", pch=20, cex.symbols=2,
      xlab="x (Number for A)", ylab="y (Number for B)", zlab="P(X=x, Y=y)")

#########################################################################

dmultinom(c(3,2,1), prob=c(0.50, 0.30, 0.20))        # example pearls 

dmultinom(c(1,1,1,3,3,3), prob=rep(1/6, 6))          # example dices
                                                           
dmultinom(c(8,1,1), prob=c(1/3, 1/3, 1/3))           # example candidates 
dmultinom(c(3,3,4), prob=c(1/3, 1/3, 1/3))
                                        
#########################################################################
                                                    
                                                          # Section 5.3.5
                                                          
                                                   # Poisson distribution
x  <- 0:12
f1 <- dpois(x, 1); f2 <- dpois(x, 2); f3 <- dpois(x, 6)
                                                            # figure 5.12    
par(mfrow=c(1,3), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f1, type="h", ylim=c(0, 0.4), xlim=c(0,12), las=1,
     ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(x, f1, pch=19, cex=1.4, col="black")
text(6, 0.18, expression(lambda == 1), cex=1.8) 
plot(x, f2, type="h", ylim=c(0, 0.3), xlim=c(0,12), las=1,
     ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(x, f2, pch=19, cex=1.4, col="black") 
text(6, 0.28, expression(lambda == 2), cex=1.8) 
plot(x, f3, type="h", ylim=c(0, 0.2), xlim=c(0,12), las=1,
     ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(x, f3, pch=19, cex=1.4, col="black") 
text(6, 0.18, expression(lambda == 6), cex=1.8) 

#########################################################################

                                                              # table 5.5        
lambda <- c(0.2, 0.5, 0.8, 1, 3, 5, 8, 12, 20)
tab <- matrix(data = NA, nrow = 30, ncol = 9, 
              byrow = FALSE, dimnames = NULL)

for (i in 0:29) {tab[i+1, ] <- round(dpois(i, lambda), 4) }; tab       

#########################################################################
                                          
dpois(0:3, 2.7397)                         # example birthday problem

                                               
dpois(3, 2)                                # example intolerance of serum       
1-ppois(2, 2,)
                                                            # figure 5.13
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(0:10, dpois(0:10, 2), type="h", ylim=c(0, 0.3), xlim=c(0,10),
     ylab="f(x)", xlab=" ", lty=2, las=1, col="grey", lwd=1)
points(0:10, dpois(0:10, 2), pch=19, cex=1.5, col="black") 
plot(0:7, ppois(0:7, 2), type="s", ylim=c(0,1), las=1,  
    xlim=c(0,10), ylab="F(x)", xlab=" ") 
lines(c(0,0), c(0,dpois(0, 2)))

#########################################################################

                                                        # Section 5.3.5.1

                                                       # dispersion index
DI_test <- function(xi, fi) {
  if (length(xi)!=length(fi)) stop("x and f unequal length!!") 
  n    <- sum(fi);    mw   <- sum(xi*fi)/n
  var  <- (sum(xi^2*fi) - (sum(xi*fi))^2/n) / (n-1)
  DI   <- mw/var
  stat <- sum(fi*(xi-mw)^2)/mw
  pvalue <- pchisq(stat, df=n-1, lower.tail=F)
  cat("\n","     Mean:",round(mw, 4),
      "\n"," Variance:",round(var,4),
      "\n","       DI:",round(DI, 4),
      "\n","Statistic:",stat,"(P-Value:", pvalue,"\b)","\n")     }

########################################################################

x <- c(  0,  1,  2, 3, 4, 5)                  # horse hoof strike deaths 
f <- c(109, 65, 22, 3, 1, 0)
DI_test(x, f)

#########################################################################

lambda <- 0.61
n      <- 200                                  # horse hoof strike deaths 
round(dpois(0:5, lambda) * n, 1)

#########################################################################

                                                        # Section 5.3.5.2 
                                                         
k <- c(3, 4); lambda <- c(9, 10)                         # approximations
z <- (k  - lambda) / sqrt(lambda); z
ppois(k, lambda)
pnorm(z)

#########################################################################
                                                        
                                                          # Section 5.3.6
                                                          
                                         # negative binomial distribution
choose(7+3-1, 7) * 0.2^3 * 0.8^7
dnbinom(7, 3, 0.2)

p <- rep(NA, 8)
for (i in 0:7) p[i+1] <- choose(i+3-1, i) * 0.2^3 * 0.8^i; sum(p)
pnbinom(7, 3, 0.2)

#########################################################################

                                                 # example number of duds
                                                        
                                                            # figure 5.14    
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(0:40, dnbinom(0:40, 3, 0.2), type="h", ylim=c(0, 0.08), las=1, 
    xlim=c(0,40), ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(0:40, dnbinom(0:40, 3, 0.2), pch=19, cex=0.5, col="black")
plot(0:40, pnbinom(0:40, 3, 0.2), type="s", ylim=c(0,1), las=1,
    xlim=c(0,40), ylab="F(x)", xlab=" ")
lines(c(0,0), c(0,pnbinom(0, 3,0.2)))


#########################################################################
                                             
p <- 0.4; x <- 10; k <- 5                     # example throw with stones
choose(x-1, k-1)*p^k*(1-p)^(x-k)
#        Number of failed attempts x-k and the number of successes k    #
dnbinom(x-k, k, 0.4)

#########################################################################
                                                        
k   <- c(  0,   1,  2,  3, 4, 5)                   # exposure and illness
obs <- c(447, 132, 42, 21, 3, 2); n <- sum(obs)
m   <- sum(obs*k)/n; round(m, 2)               # mean (expected value)   
round(dpois(k, m) * n, 0)                      # Poisson distribution          
v   <- sum((obs*(k - m)^2))/(n-1); v           # (emp.) variance                
p   <- m / v;  r <- m*p/(1-p)                  # Model parameter               
round(dnbinom(k, r, p) * n, 0)                 # negative binomial distr.   

#########################################################################

                                                          # example ticks

observed <- c(rep(0,7), rep(1,9), rep(2,8), rep(3,13), rep(4,8), rep(5,5), 
          rep(6,4), rep(7,3), rep(8,0), rep(9,1), 10, 10); 
n  <- sum(observed) 
r.hat <- mean(observed)^2/(var(observed)-mean(observed)); r.hat
p.hat <- r.hat/(mean(observed)+r.hat); p.hat
round(dnbinom(0:11, 3.96, 0.55)*60, 0)

#########################################################################

                                                  # example branded goods

observed <- c(rep(0,39), rep(1,14), rep(2,10), rep(3,6), rep(4,4), rep(5,4),
          rep(6,3), rep(7,3), rep(8,2), rep(9,2), rep(10, 13))
n  <- sum(observed); m  <- mean(observed); m 
v  <- var(observed)
r  <- m^2 / (v - m); r 

m  <- 3.4;  s  <- 0.5;  p  <- s/(s+m)            # example branded goods               
n=100; x  <- 0:10
round(dnbinom(x, s, p)*n, 0)
round(dpois(x, m)*n, 0)

#########################################################################
                                                          
                                                          # Section 5.3.7
                                                 
p <- 1/6; n <- 0:20                              # geometric distribution 
f <- dgeom(n, p)
F <- pgeom(n, p)
                                                           #  figure 5.15
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(n, f, type="h", ylim=c(0, 0.2), las=1,
        xlim=c(0,20), ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(n, f, pch=19, cex=0.5, col="black")
plot(n, F, type="s", ylim=c(0,1), las=1,
     xlim=c(0,20), ylab="F(x)", xlab=" ")
lines(c(0,0), c(0,p))

#########################################################################
                                                           
                                                          # Section 5.3.8
                                                          
                                           # hypergeometric distribution

dhyper(2, 5, 10, 5)                        # example urn model
                                                      
dhyper(1:5, 6, 4, 5)                       # example students
phyper(1:5, 6, 4, 5)
                                                        
dhyper(4, 6, 43, 6)                        # example Lotto

#########################################################################
                                                           
x <- 0:6
f <- dhyper(0:6, 6, 43, 6); F <- phyper(0:6, 6, 43, 6)
                                                            # figure 5.16 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f, type="h", ylim=c(0, 0.5), xlim=c(0,7), las=1,
     ylab="f(x)", xlab=" ", lty=2, col="grey", lwd=1)
points(x, f, pch=19, cex=1.0, col="black") 
plot(x, F, type="s", ylim=c(0,1), las=1, 
     xlim=c(0,7), ylab="F(x)", xlab=" ") 
lines(c(0,0), c(0,dhyper(0, 6, 43, 6)))

#########################################################################
                                                   
dhyper(50, 95, 5, 50)                           # example defective goods
dhyper(49, 95, 5, 50)

#########################################################################

dhyper(0, 10, 42, 15)                 # example advertisement in magazine

#########################################################################

                                                          # Section 5.3.9

                                   # negative hypergeometric distribution

nhyper <- function(W, S, k, s) {
  p <- choose(s+k-1, s) * choose(W-k + S-s, W-k) / choose(W+S, W)
  m <- k*S / (W+1)
  v <- k*(S+W+1)*S*(W-k+1) / ((W+1)*(W+1)*(W+2))
  cat("P = ", round(p, 4), "\n","Expected value: ", 
                         m,"\n","Variance......: ",v,"\n")
}
nhyper(W=2, S=3, k=2, 0:3)

#########################################################################

nhyper(W=7, S=10, k=3, 0:10)                          # example urn model

#########################################################################
                                                           
                                                          # Section 5.4.1
                                                   
a <- 2; b <- 6                                     # uniform distribution
x <- seq(a, b, by=0.01)
f <- dunif(x, a, b); F <- punif(x, a, b)
                                                            # figure 5.17
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f, type="l", ylim=c(0, 0.3), xlim=c(a-1,b+1), las=1,
            ylab="f(x)", xlab=" ", lty=1, lwd=2)
lines(c(0,a) , c(0, 0))
lines(c(a,a), c(0, dunif(a, a, b)), col="grey")
lines(c(b,b), c(0, dunif(b, a, b)), col="grey")
lines(c(b, b+1), c(0, 0))
plot(x, F, type="l", ylim=c(0,1), lwd=2, las=1,
            xlim=c(a-1,b+1), ylab="F(x)", xlab=" ")
lines(c(0,a), c(0,0))
lines(c(b, b+1), c(1,1)) 


#########################################################################
                                                           
                                                          # Section 5.4.2
                                                           
                                             # standard beta distribution
x  <- seq(0, 1, by =0.01)
                                                            # figure 5.18 
par(mfrow=c(3,2), lwd=2, font=2, font.axis=2, font.lab=2, bty="l", ps=16) 

t <- c("(a)","(b)","(c)","(d)","(e)","(f)")
p <- c(0.5, 2, 2, 1, 3, 0.5);    q <- c(  2, 3, 2, 1, 2, 0.5) 

for (i in 1:6)  {
  plot(x, dbeta(x, p[i], q[i]), type="l", xlab=" ", ylab="f(x)", las=1,
  main=paste(t[i]," p=",p[i],", q=",q[i]))   }

#########################################################################

                                                         # example profit
x <- c(0.06, 0.08, 0.15, 0.32, 0.41, 0.46, 0.47, 0.47, 0.47, 0.51, 
       0.59, 0.59, 0.64, 0.69, 0.71, 0.81, 0.89, 0.91, 0.92, 0.96)
m <- mean(x); s <- sd(x)
p1 <- m * ( m*(1-m)/s^2 - 1); p1
q1 <- (1-m) * ( m*(1-m)/s^2 - 1); q1
W <- 1-pbeta(0.8, p1, q1); W 

#########################################################################

n <- 24; k <- 17                                          # example polio
p2 <- k+1; p2
q2 <- n - k +1; q2
W <- pbeta(0.6, p2, q2); W

#########################################################################
                                                            
x <- seq(0, 1, by=0.01)                                     # figure 5.19
fbeta1 <- dbeta(x, p1, q1)      
fbeta2 <- dbeta(x, p2, q2)

par(mfrow=c(1,2), lwd=2, font=2, font.axis=2, 
          font.lab=2, bty="l", ps=14) 
x <- seq(0, 1, by=0.01)
plot(x, fbeta1, type="l", las=1,
        xlab="Proportional profit (daily)", ylab="f(x)")
x1 <- seq(0.8, 1, by=0.01)
p1 <- 1.311217; q1 <- 1.049210
y1 <- dbeta(x1, p1, q1)
x1 <- c(0.8, x1); y1 <- c(0,   y1)
text(0.65, 0.5, "23.6%")
text(0.3,0.75, expression(hat(p) == 1.31),cex=1.1)
text(0.3,0.65, expression(hat(q) == 1.05),cex=1.1)
polygon(x1, y1, density = 15, angle = 45)
plot(x, fbeta2, type="l", las=1, 
    xlab="Proportion of women that state Polio is contagious", 
    ylab="f(x)")
x2 <- seq(0, 0.6, by=0.01)
p2 <- 18; q2 <- 8
y2 <- dbeta(x2, p2, q2)
x2 <- c(x2, 0.6); y2 <- c(y2, 0)
text(0.40, 1, "15.4%")
text(0.3,2.80, expression(hat(p) == 18),cex=1.1)
text(0.28,2.45, expression(hat(q) == 8),cex=1.1)
polygon(x2, y2, density = 15, angle = 45)

#########################################################################
                                          
n <- 250;   p <- 0.05                     # example machine parts
pbinom(15, n, p) - pbinom(10, n, p)
                                          
k <- 6; p <- k+1                          # example loans  
n <- 500; q <- n-k+1 
pbeta(0.02, p, q) - pbeta(0.01, p, q)
                                          
pnbinom(850-200, 200, 0.25)               # example customer satisfaction

#########################################################################

                                                            # figure 5.21
par(mfrow=c(1,3), lwd=2, font=2, font.axis=2, font.lab=2, bty="l", ps=16) 
n <- 250;   p <- 0.05 ; x <- seq(0, 30, by=1)
fbin <- dbinom(x, n, p)
plot(x, fbin, xlab="Number of defective parts", ylab=" ",
     main="Binomial Distribution", las=1)
for (i in 1:n) lines(c(x[i],x[i]),c(0,fbin[i])) 
                        
k <- 6; p <- k+1   
n <- 500; q <- n-k+1 
x <- seq(0, 0.04, by = 0.001)
fbeta <- dbeta(x, p, q)
plot(x, fbeta, type="l", xlab="Probability of loans",
     ylab=" ", main="Standard Beta Distribution", las=1)

x     <- seq(600, 1000, by = 10); n <- length(x)
fnbin <- dnbinom(x-200, 200, 0.25)
plot(x, fnbin, xlab="Number of sending out questionaires", ylab=" ",
     main="Negative Binomial Distribution", las=1)
for (i in 1:n) lines(c(x[i],x[i]),c(0,fnbin[i]),col="grey") 

#########################################################################
                                                          
                                                          # Section 5.4.3
                                                          
e <- exp(1); x <- seq(-3.5, +3.5, by=0.05)          # normal distribution
y1 <- 3 * e^(-x^2/3)
y2 <- e^(-x^2)
                                                            # figure 5.22  
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, y1, type="l", lty=4, ylab=" ", ylim=c(0, 3.2), 
            lwd=3, xlab=" ", xlim=c(-3.5,3.5), axes=FALSE)
axis(1, at=NULL, pos=0, xlab="x") 
axis(2, at=NULL, pos=0, las=1)
lines(x, y2, lty=1, lwd=3)
text(-1.5, 2.5, expression(g(x) == 3*e^frac(-x^2, 3)), cex=1.3)
text(0, 3.2, "y", cex=1.5)
text(1.3, 0.7, expression(f(x)==e^-x^2), cex=1.3) 
text(3.7, 0, "x", cex=1.5)    

#########################################################################
                                                         
mue <- 90; sig <- 10                                        # figure 5.23 
x   <- seq(60, 120, by=0.01); f   <- dnorm(x, mean=mue, sd=sig)
                                                     
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f, type="l", ylim=c(-0.005,0.05), xlim=c(40, 140),
                ylab="f(x)", xlab=" ", lwd=2, axes=FALSE)
axis(2, las=1)
text(65,0.045,expression(y == frac(1, sigma*sqrt(2*pi))* 
                        ~~ exp(- ~~ frac((x-mu)^2, 2*sigma^2))), cex=1.5)    
lines(c(0,140), c(0,0))
lines(c(mue,mue), c(0,dnorm(mue, mean=mue, sd=sig)))
text(mue, -0.003, expression(mu), cex=1.7)
lines(c(mue-sig, mue-sig), 
      c(0, dnorm(mue-sig, mean=mue, sd=sig)), lty=2)
text(mue-sig, -0.003, expression(mu-sigma), cex=1.5)
lines(c(mue+sig, mue+sig), 
      c(0, dnorm(mue+sig, mean=mue, sd=sig)), lty=2)
text(mue+sig, -0.003, expression(mu+sigma), cex=1.5)
points(mue-sig, dnorm(mue-sig, mean=mue, sd=sig), cex=2)
text(mue-sig-10, 0.025, "inflection point")
points(mue+sig, dnorm(mue+sig, mean=mue, sd=sig), cex=2)
text(mue+sig+10, 0.025, "inflection point")
lines(c(mue-3*sig, mue-3*sig), 
      c(0, dnorm(mue-3*sig, mean=mue, sd=sig)), lty=3)
text(mue-3*sig, -0.003, expression(mu-3*sigma), cex=1.3)
lines(c(mue+3*sig, mue+3*sig), 
      c(0, dnorm(mue+3*sig, mean=mue, sd=sig)), lty=2)
text(mue+3*sig, -0.003, expression(mu+3*sigma), cex=1.3)

#########################################################################
                                                          
z <- seq(-3, +3, by=0.01)                                   # figure 5.24 
f <- dnorm(z, mean=0, sd=1); F <- pnorm(z, mean=0, sd=1)
                                                     
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(z, f, type="l", ylim=c(0, 0.4), xlim=c(-3.5, 3.5), las=1,
        ylab="f(z)", xlab=" ", lwd=2)
lines(c(-3.5, +3.5), c(0,0))
lines(c(0,0), c(0, dnorm(0,mean=0, sd=1)), lty=2, col="grey")
z1 <- seq(-4, -0.8, by=0.01)
f1 <- dnorm(z1, mean=0, sd=1)
polygon(c(z1,-0.8), c(f1,0), density = 20, angle = 45, col="black")
text(-2.5, 0.2, "F(-0.8)", cex=1.2)

plot(z, F, type="l", ylim=c(0, 1), xlim=c(-3.5, 3.5), las=1, 
           ylab="F(z)", xlab=" ", lwd=2)
lines(c(-3.5, +3.5), c(0,0))
lines(c(0,0), c(0, pnorm(0,mean=0, sd=1)), lty=2, col="grey")     
lines(c(-0.8, -0.8), c(0, pnorm(-0.8, mean=0, sd=1)), col="black")
lines(c(-4, -0.8), c(pnorm(-0.8, mean=0, sd=1), 
                   pnorm(-0.8, mean=0, sd=1)), col="black")      
text(-2.3, 0.28, "F(-0.8)", cex=1.2)

#########################################################################
                                                              
z <- seq(0, -3, by=-0.01); F <- pnorm(z, mean=0, sd=1)        # table 5.6

tab <- matrix(data = NA, nrow = 30, ncol = 10, 
                    byrow = FALSE, dimnames = NULL)
for (i in 1:30) tab[i,] <- round(F[((i-1)*10+1):((i-1)*10+10)],5)

ztr <- seq(0.0, -2.9, by=-0.1)
tab <- cbind(ztr, tab); tab  

#########################################################################

                                            # example fasting blood sugar
mue <- 90; sig <- 10                                                        
x   <- seq(60, 120, by=0.01); f   <- dnorm(x, mean=mue, sd=sig)

                                                            # figure 5.25
par(mfrow=c(1,3), lwd=2, font.axis=2, bty="n", ps=16)
plot(x, f, type="l", ylim=c(0, 0.045), xlim=c(55,125), las=1, 
            ylab=" ", xlab=" ", lwd=2)
xi <- seq(55, 75, by=0.01)
fi <- dnorm(xi, mean=mue, sd=sig)
polygon(c(xi, 75), c(fi, 0), density=20, angle=45, 
        col="black", border=TRUE) 
plot(x, f, type="l", ylim=c(0, 0.045), xlim=c(55,125), las=1,
            ylab=" ", xlab=" ", lwd=2)
xi <- seq(100,125, by=0.01)
fi <- dnorm(xi, mean=mue, sd=sig)
polygon(c(xi, 100), c(fi, 0), density=20, angle=45, 
                col="black", border=TRUE) 
plot(x, f, type="l", ylim=c(0, 0.045), xlim=c(55,125), las=1,
            ylab=" ", xlab=" ", lwd=2)
xi <- seq(85, 105, by=0.01); fi <- dnorm(xi, mean=mue, sd=sig)
polygon(c(xi, 105, 85), c(fi, 0, 0), density=20, 
                angle=45, col="black", border=TRUE) 

#########################################################################

pnorm(75, mean=90, sd=10)

pnorm(100, mean=90, sd=10, lower.tail=FALSE)

pnorm(105, mean=90, sd=10) - pnorm(85, mean=90, sd=10)

#########################################################################
                                                        
                                                        # Section 5.4.3.2
                                                       
mue <- 80; sig <-  8                                    # example 1 and 2  
low <- mue - 3.5*sig; upp <- mue + 3.5*sig
x   <- seq(low, upp, by =0.1)
f   <- dnorm(x, mean=mue, sd =sig)

                                                            # figure 5.27   
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f, type="l", las=1, xlim=c(low, upp), xlab=" ", ylab=" ")
x1 <- seq(mue-3.5*sig, qnorm(0.025, mean=mue, sd=sig), by=0.01)
f1 <- dnorm(x1, mean=mue, sd=sig)
x2 <- seq(qnorm(0.975, mean=mue, sd=sig), mue+3.5*sig, by=0.01)
f2 <- dnorm(x2, mean=mue, sd=sig)
polygon(c(x1,qnorm(0.025, mean=mue, sd=sig)), 
        c(f1,0), density = 20, angle = 45)
polygon(c(qnorm(0.975, mean=mue, sd=sig),x2), 
        c(0,f2), density = 20, angle = 45)
                                                        
qnorm(0.025, mean=mue, sd=sig)                               # example 2        

qnorm(0.975, mean=mue, sd=sig)

########################################################################
                                                   
mue <- 0; sig <- 1                                           # example 3        
low <- mue - 3.5*sig; upp <- mue + 3.5*sig
x   <- seq(low, upp, by =0.1); f   <- dnorm(x, mean=mue, sd =sig)
                                                           # figure 5.28   
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14) 
plot(x, f, type="l", las=1, xlim=c(low, upp), xlab=" ", ylab=" ")
x1 <- seq(-1, 1.5, by=0.01)
f1 <- dnorm(x1, mean=mue, sd=sig)
polygon(c(-1,x1,1.5), c(0,f1,0), density = 10, angle = 45)
text(2, 0.25, "77,45%", cex=1.5)

########################################################################
                                                        
mue <- 150; sig <-  10                                      #  example 4       
qnorm(0.06, mean=mue, sd=sig)
pnorm(160, mean=mue, sd=sig) - pnorm(130, mean=mue, sd=sig)
qnorm(0.025, mean=mue, sd=sig)
qnorm(0.975, mean=mue, sd=sig)

########################################################################
                                                          
mue <- 12; sig <-  2;  n <- 100;                             # example 6        
y.val <- rnorm(n, mean=mue, sd=sig)
brk <- c(3, 5, 7, 9, 11, 13, 15, 17, 19, 21) 
                                                           # figure 5.29   
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14) 
hist(y.val, breaks = brk, las=1, ylim=c(0,40), xlim=c(0,20), main=" ",
     border="darkgrey", xlab=" ", ylab="Frequency", col="grey")
mid <- c(4, 6, 8, 10, 12, 14, 16, 18, 20)
z.val <- (mid - mean(y.val)) / sd(y.val)
f.val <- dnorm(z.val, mean=0, sd=1)
y.est <- (2 * n / sd(y.val)) * f.val
lines(mid, y.est)  

#########################################################################

                                                          # Section 5.4.4 

                                               # half-normal distribution

                                                         # density
dhalfnorm <- function(x, s)  (sqrt(2)/(s*sqrt(pi)))*exp(-x^2/(2*s^2))
                                                         # error function
erf       <- function(x) 2 * pnorm(x * sqrt(2)) - 1
                                                         # distribution
phalfnorm <- function(x, s) erf(x/(s*sqrt(2)))
                                                         # quantiles
qhalfnorm <- function(p, s) s * qnorm((1+p)/2)

#########################################################################

sigma <- 1                                                  # figure 5.30
x     <- seq(-2, +2, by=0.01)

par(mfcol=c(1,1), lwd=2.5, font.axis=2, bty="l", ps=14)  
plot(x, erf(x), type="l", las=1, xlab=" ", 
     ylab="Error function erf(x)", axes=F, lwd= 2)
axis(1, pos=0, lty=1, lwd=1, las=1, xlim=c(-2, +2), xaxp=c(-2, +2, 20)) 
axis(2, pos=0, lty=1, lwd=2, las=1, ylim=c(-1, +2), yaxp=c(-1, +1, 10))
abline(h=seq(-1,+1,0.2), col="grey", lty=2, lwd=1.5)

#########################################################################

sigma <- c(1, 2, 3)                                         # figure 5.31
x     <- seq(0, 8, by=0.02)

par(mfcol=c(1,2), lwd=3, font.axis=2, bty="l", ps=14)  
plot(x, dhalfnorm(x, sigma[1]), type="l", las=1, xlab=" ", ylab="f(x)",
     xlim=c(0,6), ylim=c(0,0.8), lty=1)
lines(x, dhalfnorm(x, sigma[2]), lty=2)
lines(x, dhalfnorm(x, sigma[3]), lty=3)
abline(h=seq(0,0.8,0.2), col="grey", lty=2, lwd=1.5)
ltxt <- c(expression(sigma == 1),expression(sigma == 2),expression(sigma == 3))
legend(4, 0.8, legend = ltxt, lty=1:3, bty="n", cex=1.4)

plot(x, phalfnorm(x, sigma[1]), type="l", las=1, xlab=" ", ylab="F(x)",
     xlim=c(0,6), ylim=c(0,1), lty=1)
lines(x, phalfnorm(x, sigma[2]), lty=2)
lines(x, phalfnorm(x, sigma[3]), lty=3)
abline(h=seq(0,1,0.2), col="grey", lty=2, lwd=1.5)
legend(4, 0.23, legend = ltxt, lty=1:3, bty="n", cex=1.4)

#########################################################################

                                         # example jaw model measurements
x <- c(-0.0554, -0.0165, 0.0156,  0.0115, -0.0544, 
        0.0094,  0.0076, 0.0253, -0.0226, -0.0306)
n <- length(x)
s.hat <- sqrt(sum(x^2)/n); round(s.hat, 4)            # estimate
sigma <- 0.03
E <- sigma*sqrt(2/pi); E                              # expected value
qhalfnorm(0.5, sigma)                                 # median value
qhalfnorm(0.10, sigma); qhalfnorm(0.95, sigma)


#########################################################################

                                                          # Section 5.4.5 

                                          # truncated normal distribution

truncnorm <- function(x, a=-Inf, b=+Inf, mu, sigma) {
    za <- (a-mu)/sigma; zb <- (b-mu)/sigma; z <- (x-mu)/sigma
    dz <- dnorm(z); da <- dnorm(za); db <- dnorm(zb)   
    pz <- pnorm(z); pa <- pnorm(za); pb <- pnorm(zb)
    f  <- dz / (sigma*(pb - pa))                  # density function
    F  <- (pz - pa) / (pb-pa)                     # distribution function
    EX <- mu + ((da - db)/(pb - pa))*sigma        # expected value
    VX <- sigma^2*(1 + (za*da - zb*db)/(pb - pa)  # variance
                   - ((da-db)/(pb-pa))^2)
    return(list(pdf=f, cdf=F, M=EX, V=VX))
}

#########################################################################

                                                            # figure 5.32 
mu    <- 100;  sigma <- c(6, 8, 10)
a <- 95; b <- 115
x     <- seq(a, b, 0.5)
n     <- length(x)
distr1 <- truncnorm(x, a, b, mu, sigma[1])
distr2 <- truncnorm(x, a, b, mu, sigma[2])
distr3 <- truncnorm(x, a, b, mu, sigma[3])

par(mfrow=c(1,2), lwd=1.5, font.axis=2, bty="l", ps=14)
plot(x, distr1$pdf, las=1, type="l", lwd=2, lty=1,
     xlim=c(90, 120), ylim=c(0, 0.09),
     xlab=" ", ylab="f(x)")
lines(x, distr2$pdf, lty=2, lwd=2)
lines(x, distr3$pdf, lty=3, lwd=2)
lines(c(x[1],x[1]), c(0,distr1$pdf[1]), lwd=2) 
lines(c(x[n],x[n]), c(0,distr3$pdf[n]), lwd=2)
ltxt <- c(expression(mu == 100), expression(sigma == 6),
          expression(sigma == 8), expression(sigma == 10))
legend(105, 0.09, legend = ltxt, lty=0:3, bty="n", cex=1.4, lwd=2)

plot(x, distr1$cdf, las=1, type="l",lwd=2,
     xlim=c(90, 120), ylim=c(0,1),
     xlab=" ", ylab="F(x)")
lines(x, distr2$cdf, lty=2, lwd=2)
lines(x, distr3$cdf, lty=3, lwd=2)
lines(c(x[1],x[1]), c(0,distr1$cdf[1]), lwd=2) 
lines(c(x[n],x[n]), c(0,distr1$cdf[n]), lwd=2)
legend(90, 0.9, legend = ltxt, lty=0:3, bty="n", cex=1.4, lwd=2)


#########################################################################

                                                   # example screw length
truncnorm(x=10.4, a=9.5, b=10.5, mu=10, sigma=0.3)

library(truncnorm)
ptruncnorm(10.4, a=9.5, b=10.5, mean=10, sd=0.3)
etruncnorm( a=9.5, b=10.5, mean=10, sd=0.3)
vtruncnorm( a=9.5, b=10.5, mean=10, sd=0.3)

#########################################################################
                                                          
                                                          # Section 5.4.6                                                         
                                                  
x <- seq(0, 10, by=0.01)                        # log-mormal distribution
f <- dlnorm(x, meanlog=1, sdlog=0.5)
F <- plnorm(x, meanlog=1, sdlog=0.5)
                                                            # figure 5.33 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, f, type="l", ylim=c(0, 0.4), xlim=c(0, 10), las=1,
     ylab="f(z)", xlab=" ",  lwd=2)
plot(x, F, type="l", ylim=c(0, 1), xlim=c(0, 10), las=1,
     ylab="F(z)", xlab=" ",  lwd=2)

########################################################################

age <- c(36, 44, 38, 41, 26, 59, 27, 26, 34, 30,    # example fatherhood
         42, 29, 31, 21, 28, 20, 24, 32, 40, 23)        
n   <- length(age)

mue  <- sum(log(age))/n; mue                        # estimation mue       
s2   <- sum((log(age)-mue)^2)/n; s2                 # estimation sigma^2   

mue.age <- exp(mue + 0.5*s2); mue.age                  # expected value
s2.age  <- exp(2*mue + s2)*(exp(s2)-1); sqrt(s2.age)   # variance     

ms.age <- exp(mue); ms.age                          # Limpert xq-star     
ss.age <- exp(sqrt(sum(log(age/ms.age)^2)/(n-1)))
ss.age                                              # Limpert sd-star  

#########################################################################

                                                            # figure 5.34       
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
x    <- seq(12, 70, by=0.5)
f    <- dlnorm(x, meanlog=3.5, sdlog=sqrt(0.07))
plot(x, f, xlab="Age at 1st fatherhood", ylab="f(x)", las=1, 
            type="l", ylim=c(0,0.05))
x1 <- seq(23.8, 41.5, by=0.5)
f1 <- dlnorm(x1, meanlog=3.5, sdlog=sqrt(0.07))
polygon(c(23.8,x1,41.5), c(0,f1,0), density = 10, angle = 45)
text(50, 0.03, "68,3%", cex=1.2)
F    <- plnorm(x, meanlog=3.5, sdlog=sqrt(0.07))
plot(x, F, xlab="Age at 1st fatherhood", ylab="F(x)", las=1,
            type="l", ylim=c(0,1))
abline(h=0.5, lty=2)
abline(v=exp(3.5), lty=2)

#########################################################################

library(MASS)
fitdistr(age, "lognormal")                  # fitdistr() in library(MASS)

#########################################################################

                         # empirical measures of a lognormal distribution

                                                # example 20 measurements
x    <- c(3, 4, 5, 5, 5, 5, 5, 6, 7, 7, 7, 7, 8, 8, 9, 9, 10, 11, 12, 14)
lgx  <- log10(x); lgx2 <- lgx^2
tab <- cbind(x, lgx, lgx2); tab

lgx  <- log10(x)
lgx2 <- lgx^2
median.L <- 10^mean(lgx); median.L                      # median
disp.L   <- 10^(sqrt(sd(lgx)^2));  disp.L               # dispersion
mean.L   <- 10^(mean(lgx)+1.1513*sd(lgx)^2);  mean.L    # mean
densm.L  <- 10^(mean(lgx)-2.3026*sd(lgx)^2); densm.L    # density mean

#########################################################################
                                           
                                                          # Section 5.4.5
                                                                                                          
x <- seq(0, 4, by=0.01)                        # exponential distribution
fx1 <- dexp(x, rate=1);  Fx1 <- pexp(x, rate=1)
fx2 <- dexp(x, rate=5);  Fx2 <- pexp(x, rate=5)
fx3 <- dexp(x, rate=10); Fx3 <- pexp(x, rate=10)
                                                            # figure 5.35 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fx1, type="l", ylim=c(0, 2), xlim=c(0, 4), las=1,
            ylab="f(x)", xlab=" ", lwd=2, lty=1)
lines(x, fx2, type="l", lwd=2, lty=2)
lines(x, fx3, type="l", lwd=2, lty=3)
legend(1.5, 1, bty="n", c(expression(lambda ==1), expression(lambda ==5),
            expression(lambda ==10)), lty=c(1,2,3), cex=1.4)

plot(x, Fx1, type="l", ylim=c(0, 1), xlim=c(0, 4), las=1,
            ylab="F(x)", xlab=" ", lwd=2, lty=1)
lines(x, Fx2, type="l", lwd=2, lty=2)
lines(x, Fx3, type="l", lwd=2, lty=3)
legend(1.5, 0.5, bty="n", c(expression(lambda ==1), 
            expression(lambda ==5), expression(lambda ==10)), 
       lty=c(1,2,3), cex=1.4)

#########################################################################

1 - pexp(4, rate = 0.5)                       # example waiting time

1 - pexp(110, rate=0.01)                      # example lifespan of bulbs

#########################################################################
                                                          
                                                          # Section 5.4.8
                                                          
x <- seq(0, 3.5, by=0.01)                          # Weibull distribution

fxa1 <- dweibull(x, 1.5, 0.5)
fxa2 <- dweibull(x, 1.5, 1)
fxa3 <- dweibull(x, 1.5, 2)

fxb1 <- dweibull(x, 1, 1)
fxb2 <- dweibull(x, 2, 1)
fxb3 <- dweibull(x, 3, 1)

                                                            # figure 5.35 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fxa1, type="l", ylim=c(0, 1.5), xlim=c(0, 3.5), las=1, 
            ylab="f(x)", xlab=" ", lwd=2, lty=1)
lines(x, fxa2, type="l", lwd=2, lty=2)
lines(x, fxa3, type="l", lwd=2, lty=3)
legend(1.5, 1, bty="n", c(expression(alpha==0.5), expression(alpha==1),
            expression(alpha==2)), lty=c(1,2,3), cex=1.5)
text(2.5,1.05,expression(beta==1.5), cex=1.5)

plot(x, fxb1, type="l", ylim=c(0, 1.5), xlim=c(0, 3.5), las=1,
            ylab="f(x)", xlab=" ", lwd=2, lty=1)
lines(x, fxb2, type="l", lwd=2, lty=2)
lines(x, fxb3, type="l", lwd=2, lty=3)
legend(2, 1, bty="n", c(expression(beta==1), expression(beta==2),
            expression(beta==3)), lty=c(1,2,3), cex=1.5)
text(2.5,1.05,expression(alpha==1.0), cex=1.5)
#
#########################################################################

                                           # reliability and failure rate

                                                            # figure 5.37
x <- seq(0, 3.5, by=0.01)
beta <- c(1, 1.2, .2); alpha <- 1

par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
Rx   <- matrix( 0, nrow=3, ncol=length(x))
for (i in 1:3) Rx[i,]= exp(-(x/alpha)^beta[i])
plot(x, Rx[1,], type="l", ylim=c(0, 1.0), xlim=c(0, 3.5), las=1,
     ylab="R(x)", xlab=" ", main="Reliability", lwd=2, lty=1)
lines(x, Rx[2,], type="l", lwd=2, lty=2)
lines(x, Rx[3,], type="l", lwd=2, lty=3)
legend(2.0, 0.8, bty="n", c(expression(beta==1.0), expression(beta==1.2),
                        expression(beta==0.2)), lty=c(1,2,3), cex=1.4)
text(2.8, 0.82,expression(alpha==1), cex=1.4)

hx   <- matrix( 0, nrow=3, ncol=length(x))
for (i in 1:3) hx[i,] <- beta[i]/alpha*(x/alpha)^(beta[i]-1)
plot(x, hx[1,], type="l", ylim=c(0, 1.5), xlim=c(0, 3.5), las=1,
     ylab="h(x)", xlab=" ", main="Failure rate", lwd=2, lty=1)
lines(x, hx[2,], type="l", lwd=2, lty=2)
lines(x, hx[3,], type="l", lwd=2, lty=3)
legend(2.0, 0.72, bty="n", c(expression(beta==1.0), expression(beta==1.2),
                          expression(beta==0.2)), lty=c(1,2,3), cex=1.4)
text(2.8, 0.74, expression(alpha==1), cex=1.4)


#########################################################################

                                                  # example fracture load
x <- seq(10, 40, by=1)                         
fx <- dweibull(x, 7, 27)
Fx <- pweibull(x, 7, 27, lower.tail = TRUE, log.p = FALSE)
pweibull(35, 7, 27) - pweibull(30, 7, 27)

                                                            # figure 5.38
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fx , type="l", ylim=c(0, 0.1), xlim=c(10, 40), las=1,
           ylab="f(x)", xlab="Fracture load [N]", lwd=2, lty=1)
x1 <- seq(30, 35, by=0.5)
f1 <- dweibull(x1, 7, 27)
polygon(c(30,x1,35), c(0,f1,0), density = 10, angle = 45)
plot(x, Fx , type="l", ylim=c(0, 1), xlim=c(10, 40), las=1,
             ylab="F(x)", xlab="Fracture load [N]", lwd=2, lty=1)
lines(c(30, 30), c(0,pweibull(30, 7, 27)), type="l", lwd=2, lty=2)
lines(c(35, 35), c(0,pweibull(35, 7, 27)), type="l", lwd=2, lty=2)

#########################################################################
 
                                                          # Section 5.4.9

                                     # extrem value distribution (Gumbel)

dgumbel <- function(x, lambda, delta, dir="max") {        # density
  z <- (x - lambda)/delta 
  if (dir=="max") return(exp(-z - exp(-z))/delta)         # maximum
  if (dir=="min") return(exp(z - exp(z))/delta)           # minimum
}
pgumbel <- function(q, lambda, delta, dir="max") {        # distribution
  z <- (q - lambda)/delta
  if (dir=="max") return(exp(-exp(-(z))))                 # maximum
  if (dir=="min") return(1 - exp(-exp(z)))                # minimum
}
qgumbel <- function(p, lambda, delta, dir="max") {        # quantiles
  if (dir=="max") return(lambda-delta*log(-log(p)))       # maximum
  if (dir=="min") return(lambda+delta*log(-log(1-p)))     # minimum
}
rgumbel <- function(n, lambda, delta) {                   # random numbers
  z <- runif(n, 0, 1)
  lambda - delta*log(-log(z))
}

#########################################################################

lambda <- 3
delta  <- c(0.6, 1.0, 1.4)
x <- seq(0, 8, 0.1)
                                                           # figure 5.39
par(mfrow=c(1,2), lwd=2.0, font.axis=2.0, bty="l", ps=14) 
plot(x, dgumbel(x, lambda, delta[1]), type ="l", las=1, lty=2,
     ylab="Gumbel density function (PDF)", ylim=c(0,0.7), xlab=" ")
lines(x, dgumbel(x, lambda, delta[2]), lty=1)
lines(x, dgumbel(x, lambda, delta[3]), lty=3)
legend(4.3, 0.4, bty="n", 
       c(expression(lambda==3.0),expression(delta ==0.6), 
         expression(delta ==1.0), expression(delta ==1.4)), 
       lty=c(0,2,1,3), cex=1.4)
abline(v=lambda)

plot(x, pgumbel(x, lambda, delta[1]), type ="l", las=1, lty=2, xlab=" ",
     ylab="Gumbel distribution function (CDF)", ylim=c(0,1.0))
lines(x, pgumbel(x, lambda, delta[2]), lty=1)
lines(x, pgumbel(x, lambda, delta[3]), lty=3)
legend(4.3, 0.5, bty="n", 
       c(expression(lambda==3.0),expression(delta ==0.6), 
         expression(delta ==1.0), expression(delta ==1.4)), 
       lty=c(0,2,1,3), cex=1.4)
abline(v=lambda)

#########################################################################

                                       # inverse distribution - quantiles
q <- seq(0,1,by=0.01)
par(mfrow=c(1,2), lwd=2.0, font.axis=2.0, bty="l", ps=14) 
plot(q, qgumbel(q, lambda, delta[1], dir="max"), type ="l", las=1, lty=2,
     xlab="Quantiles", ylab="Gumbel inverse distribution", ylim=c(-1,8))
lines(q, qgumbel(q, lambda, delta[2], dir="max"), lty=1)
lines(q, qgumbel(q, lambda, delta[3], dir="max"), lty=3)
legend(0.7, 2, bty="n", 
       c(expression(lambda==3.0),expression(delta ==0.6), 
         expression(delta ==1.0), expression(delta ==1.4)), 
       lty=c(0,2,1,3), cex=1.2)
abline(h=lambda)
text(0.5, 8, "Extreme value - maxima")

plot(q, qgumbel(q, lambda, delta[1], dir="min"), type ="l", las=1, lty=2,
     xlab="Quantiles", ylab="Gumbel inverse distribtution", ylim=c(-1,8))
lines(q, qgumbel(q, lambda, delta[2], dir="min"), lty=1)
lines(q, qgumbel(q, lambda, delta[3], dir="min"), lty=3)
legend(0.7, 2, bty="n", 
       c(expression(lambda==3.0),expression(delta ==0.6), 
         expression(delta ==1.0), expression(delta ==1.4)), 
       lty=c(0,2,1,3), cex=1.2)
abline(h=lambda)
text(0.5, 8, "Extreme values - Minima")

#########################################################################

                                                    # example water level
hydro <- c(766, 803, 824, 833, 641, 853, 795, 763, 745, 798, 
           842, 728, 704, 755, 874, 713, 803, 723, 733, 825, 
           783, 789, 834, 772, 706, 766, 721, 775, 857, 784)  

n    <- length(hydro)                                       # figure 5.40
jahr <- 1985:2014
par(mfrow=c(1,1), lwd=2.0, font.axis=2.0, bty="l", ps=14) 
plot(jahr, hydro, cex=2, xlab=" ", ylab="Water level [cm]", las=1,
     ylim=c(500,900))
for (i in 1:n) lines(c(jahr[i],jahr[i]),c(0,hydro[i]))

#########################################################################

x <- hydro                                                   # estimation
n <- length(x); m <- mean(x)
dhat  <- uniroot(function(dhat) 
  m-(sum(x*exp(-x/dhat)))/(sum(exp(-x/dhat)))-dhat, 
  interval=c(0.5*sd(x), 2*sd(x)), tol = 1e-9)$root
lhat  <- -dhat*log(sum(exp(-x/dhat))/n)
cat("\n","Estimate for delta =",dhat,"and lambda =",lhat,"\n")

q <- c(0.90, 0.95, 0.99)                     # quantiles: 90% - 95% - 99%
round(qgumbel(q, lhat, dhat),0)

m     <- c(10, 20, 30); gamma <- 0.57722                     # prediction
prd <- lhat + (gamma + log(m)) * dhat
round(prd, 0)

#########################################################################

                                                         # Section 5.4.10

x <- seq(0.1, 4, by=0.05)                                # Gamma function  
y <- gamma(x)
                                                            # figure 5.41 
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, y, type="l", xlab=" ", ylab=expression(Gamma(x)), las=1, 
     ylim=c(0,10), xlim=c(0, 4))

#########################################################################

                                                     # Gamma distribution 
x <- seq(0, 3, by=0.01)
fx1 <- dgamma(x, 0.5, rate = 3)
fx2 <- dgamma(x, 1, rate = 3)
fx3 <- dgamma(x, 2, rate = 3)
fx4 <- dgamma(x, 4, rate = 3)

Fx1 <- pgamma(x, 0.5, rate = 3)
Fx2 <- pgamma(x, 1, rate = 3)
Fx3 <- pgamma(x, 2, rate = 3)
Fx4 <- pgamma(x, 4, rate = 3)
                                                            # figure 5.42  
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fx1, type="l", ylim=c(0, 3.5), xlim=c(0, 3), las=1, 
            ylab="f(x)", xlab=" ",  lwd=2, lty=1)
lines(x, fx2, type="l", lwd=2, lty=2)
lines(x, fx3, type="l", lwd=2, lty=3)
lines(x, fx4, type="l", lwd=2, lty=4)
legend(1.8, 3, bty="n", c(expression(k==0.5), expression(k==1),
            expression(k==2),expression(k==4)), lty=c(1,2,3,4), cex=1.5)
text(2.5,3.05, expression(lambda==3), cex=1.5)

plot(x, Fx1, type="l", ylim=c(0, 1), xlim=c(0, 3), las=1,
            ylab="F(x)", xlab=" ", lwd=2, lty=1)
lines(x, Fx2, type="l", lwd=2, lty=2)
lines(x, Fx3, type="l", lwd=2, lty=3)
lines(x, Fx4, type="l", lwd=2, lty=4)
legend(1.8, 0.67, bty="n", c(expression(k==0.5), expression(k==1),
            expression(k==2),expression(k==4)), lty=c(1,2,3,4), cex=1.5)
text(2.5, 0.70, expression(lambda==3), cex=1.5)

#########################################################################

                                              # example pressure vessels
time <- c(274.0,   1.7,  871.0, 1311.0, 236.0,  458.0,  54.9, 1787.0,   
           0.75, 776.0,    28.5,  20.8, 363.0, 1661.0, 828.0,  290.0, 
          175.0,  970.0, 1278.0, 126.0)
m.t  <- mean(time); n <- length(time)
k.hat <- (n * (m.t)^2) / sum((time - m.t)^2); round(k.hat, 4)
l.hat <- (n *  m.t   ) / sum((time - m.t)^2); round(l.hat, 4)

                                                            # figure 5.43
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
hist(time, breaks=c(0, 298, 596, 894, 1192, 1490, 1788), lwd=0.5,
     main=" ", xlab=" ", ylab="", col="lightgrey", border="grey",
     las=1, xlim=c(0,2000), ylim=c(0,0.002), freq=FALSE)

x <- seq(0, 2000, by=10)
f <- dgamma(x, k.hat,  rate = l.hat)
lines(x, f)
f <- dgamma(x, 1.45,  rate = 1/300)
lines(x, f, lty=3, col="darkgrey")

#########################################################################
                                                          
                                                            # Section 5.5
                                                          
                                               # t-distribution (Student)
x <- seq(-5, +5, by=0.01) 
fn <- dnorm(x, mean=0, sd=1); ft <- dt(x, 3)
                                                            # figure 5.44 
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fn, type="l", ylim=c(0, 0.4), xlim=c(-6, +6), las=1,
     ylab="f(x)", xlab=" ", lwd=2)
lines(x, ft, type="l", lwd=2)
abline(h=0)
abline(v=0, lty=2) 
x1 <- c(seq(-5,5,by=0.01), seq(+5,-5,by=-0.01))
f1 <- c(dnorm(seq(-5,5,by=0.01), mean=0, sd=1), 
        dt(seq(+5,-5,by=-0.01), 3))
polygon(x1,f1, density =20, angle = 45) 
lines(c(1,2),c(dt(1,3),0.3), lwd=2)
text(3.5,0.31, "t-distribution (3 degrees of freedom)", cex=1.2)
lines(c(-0.5,-2),c(dnorm(-0.5,mean=0,sd=1),0.32), lwd=2)
text(-3, 0.31, "Standard normal distribution", cex=1.2)
                            
#########################################################################

x <- seq(-6, +6, by=0.01)                                   # figure 5.45
ft1 <- dt(x, 1); Ft1 <- pt(x, 1)
ft2 <- dt(x, 3); Ft2 <- pt(x, 3)
ft3 <- dt(x, 8); Ft3 <- pt(x, 8)
                                                          
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, ft1, type="l", ylim=c(0, 0.4), xlim=c(-6, +6), las=1, 
     ylab="f(x)", xlab=" ", lwd=2, lty=3)
abline(v=0, lty=2, col="grey")
lines(x, ft2, type="l", lwd=2, lty=2)
lines(x, ft3, type="l", lwd=2, lty=1)
legend(1.5, 0.4, bty="n", c("DF=1","DF=3","DF=8"), 
       lty=c(3,2,1), cex=1.2)
plot(x, Ft1, type="l", ylim=c(0, 1), xlim=c(-6, +6), las=1, 
     ylab="F(x)", xlab=" ", lwd=2, lty=3)
abline(v=0, lty=2, col="grey")
lines(x, Ft2, type="l", lwd=2, lty=2)
lines(x, Ft3, type="l", lwd=2, lty=1)
legend(1.5, 0.3, bty="n", c("DF=1","DF=3","DF=8"), lty=c(3,2,1), cex=1.2)

#########################################################################

                                                              # table 5.8
fg <- c(seq(1, 20, by=1), seq(22, 50, by =2), 
        seq(55, 100, by=5), 250, 500, 1000)
alpha <- c(0.99, 0.975, 0.95, 0.90)  

tab <- matrix(NA, nrow=length(fg), ncol=length(alpha)+1)
tab[,1] <- fg
for (i in 2:5) tab[,i]=qt(alpha[i-1], fg)
tab[1:15,]
   
#########################################################################

                                              # noncentral t-distribution
                                  
                                                            # figure 5.46
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
x <- seq(-6, 12, by=0.1); d <- c(1, 2, 3, 4)
f <- dt(x, 10, ncp=0, log = FALSE)          
plot(x, f, type="l", ylim=c(0, 0.45), xlim=c(-4, 10), las=1,
                                ylab="f(x)", xlab=" ", lwd=2)
text(0, 0.4, expression(delta == 0), cex=1.3)
text(1.8, 0.38, expression(delta == 1), cex=1.3)
text(2.9, 0.35, expression(delta == 2), cex=1.3)
text(4.0, 0.32, expression(delta == 3), cex=1.3)
text(6.0, 0.2, expression(delta == 4), cex=1.3)
lt <- c(3, 4, 5, 6)
for (i in 1:4) {
f <- dt(x, 10, ncp=d[i], log = FALSE)                                            
lines(x, f, type="l", lwd=2, lty=lt[i], col="darkgrey") }


#########################################################################

                                                          # Section 5.5.2
                                                          
                                                # chi-square distribution
x <- seq(0, +20, by=0.01)
fx1 <- dchisq(x, 2);  Fx1 <- pchisq(x, 2)
fx2 <- dchisq(x, 5);  Fx2 <- pchisq(x, 5)
fx3 <- dchisq(x, 10); Fx3 <- pchisq(x, 10)

                                                            # figure 5.47 
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)

plot(x, fx1, type="l", ylim=c(0, 0.2), xlim=c(0, 20), las=1,
            ylab="f(x)", xlab=" ", lwd=2, lty=1)
lines(x, fx2, type="l", lwd=2, lty=2)
lines(x, fx3, type="l", lwd=2, lty=3)
legend(12, 0.15, bty="n", c("DF=1","DF=5","DF=10"), lty=c(1,2,3), cex=1.3)

plot(x, Fx1, type="l", ylim=c(0, 1), xlim=c(0, 20), las=1, 
            ylab="F(x)", xlab=" ", lwd=2, lty=1)
lines(x, Fx2, type="l", lwd=2, lty=2)
lines(x, Fx3, type="l", lwd=2, lty=3)
legend(12, 0.3, bty="n", c("DF=2","DF=5","DF=10"), lty=c(1,2,3), cex=1.3)

#########################################################################

pchisq(2, 5, lower.tail = TRUE)

pchisq( 3.841458, 1, lower.tail=FALSE)

#########################################################################

                                                              # table 5.9
fg <- c(seq(1, 20, by=1), seq(22, 50, by =2), 
        seq(55, 100, by=5), 250, 500, 1000)
alpha <- c(0.01, 0.025, 0.05, 0.10, 0.90, 0.95, 0.975, 0.99)  

tab <- matrix(NA, nrow=length(fg), ncol=length(alpha)+1)
tab[,1] <- fg
for (i in 2:9) tab[,i]=qchisq(alpha[i-1], fg)
tab[1:15,]

#########################################################################

                                     # noncentral chi-square distribution                                  

                                                            # figure 5.48
nu  <- c(2, 5, 10)
tt  <- c(expression(nu == 2), expression(nu == 5), expression(nu == 10))
x   <- seq(0, +20, by=0.01)
  											   													   
par(mfrow=c(1,3), lwd=2, font.axis=2, bty="n", ps=16)
for (k in 1:3) {
plot(x, dchisq(x, nu[k]), type="l", ylim=c(0, 0.3), xlim=c(0, 20), las=1, 
           col="darkgray", ylab=" ", xlab=" ", lwd=2)
text(10, 0.30, tt[k], cex=1.6)
lt <- c(1,2,3); lambda <- c(1, 2, 5)
l1 <- expression(lambda == 1)
l2 <- expression(lambda == 2)
l3 <- expression(lambda == 5)
legend(8, 0.2, bty="n", c(l1, l2, l3), lty=c(1,2,3), cex=1.6)
for (i in 1:3) lines(x, dchisq(x, nu[k], ncp=lambda[i]), 
                     type="l", lwd=2, lty=lt[i], col="black") 
}

#########################################################################

                                                          # Section 5.5.3
                                                          
                                                # F-distribution (Fisher)
x <- seq(0, 4, by=0.01)
fx1 <- df(x, 2, 5);  Fx1 <- pf(x, 2, 5)
fx2 <- df(x, 10, 10);  Fx2 <- pf(x, 10, 10)
                                                            # figure 5.49
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=14)
plot(x, fx1, type="l", ylim=c(0, 1), xlim=c(0, 4), las=1,
            ylab="f(x)", xlab=" ", lwd=2, lty=1)
lines(x, fx2, type="l", lwd=2, lty=2)
legend(1.8, 0.4, c("DF=(2, 5)","DF=(10, 10)"), bty="n", 
       lty=c(1,2), cex=1.4)
plot(x, Fx1, type="l", ylim=c(0, 1), xlim=c(0, 4), las=1,
            ylab="F(x)", xlab=" ", lwd=2, lty=1)
lines(x, Fx2, type="l", lwd=2, lty=2)
legend(1.8, 0.4, c("DF=(2, 5)","DF=(10, 10)"), bty="n", 
       lty=c(1,2), cex=1.4)

#########################################################################

                                                             # table 5.10
fg1 <- c(seq(1, 10, by=1), seq(12, 20, by =2), 25, 30, 40, 50, 100)
fg2 <- c(seq(1, 10, by=1), seq(12, 20, by =2), 25, 30, 40, 50, 100)
alpha <- 0.95

tab1 <- matrix(NA, nrow=21, ncol=11)
tab1[1,] <- c(NA, fg1[1:10])
tab1[,1] <- c(NA, fg2)
for (i in 1:20) {
    for (j in 1:10) tab1[i+1,j+1]=qf(alpha, fg1[i], fg2[j]) }
tab1[1:15,]

tab2 <- matrix(NA, nrow=21, ncol=11)
tab2[1,] <- c(NA, fg1[11:20])
tab2[,1] <- c(NA, fg2)
for (i in 1:20) {
    for (j in 1:10) tab2[i+1,j+1]=qf(alpha, fg1[i], fg2[j+10]) }
tab2[1:15,]

#########################################################################

alpha <- 0.975                                               # table 5.11

tab1 <- matrix(NA, nrow=21, ncol=11)
tab1[1,] <- c(NA, fg1[1:10])
tab1[,1] <- c(NA, fg2)
for (i in 1:20) {
    for (j in 1:10) tab1[i+1,j+1]=qf(alpha, fg1[i], fg2[j]) }
tab1[1:15,]

tab2 <- matrix(NA, nrow=21, ncol=11)
tab2[1,] <- c(NA, fg1[11:20])
tab2[,1] <- c(NA, fg2)
for (i in 1:20) {
    for (j in 1:10) tab2[i+1,j+1]=qf(alpha, fg1[i], fg2[j+10]) }
tab2[1:15,]


#########################################################################

                                                          # Section 5.5.4

                                                 # interpolation (linear)

approx(x=c(2,7), y=c(2,3), xout=c(5,6), method="linear")

approx(x=c(50, 100), y=c(4.03, 3.94), xout=70, method="linear")$y


#########################################################################

                                                            # Section 5.6
                                                            
                                            # 2-dimensional distributions

f  <- function(x, y) { x*y*exp(-(x+y)) }              # example homeworks
x  <- seq(0, 7, by=0.25)
y  <- seq(0, 7, by=0.25)
z <- outer(x, y, f)
                                                            # figure 5.51
par(mfrow=c(1,1), lwd=1.5, font.axis=2, bty="n", ps=14)
persp(x, y, z, theta = 60, phi = 20, r=10, shade=0.1, 
                              xlab="x", ylab="y", zlab="f(x,y)")

#########################################################################

x  <- seq(0, 7, by=0.3)
y  <- seq(0, 7, by=0.3)
                                                            # figure 5.52
par(mfrow=c(1,2), lwd=1.5, font.axis=2, bty="n", ps=14)
f <- function(x, y) { ifelse(x>2, 0, x*y*exp(-(x+y))) }
z <- outer(x, y, f)
persp(x, y, z, theta = 60, phi = 20, r=10, shade=0.1,
            xlab="x", ylab="y", zlab="f(x,y)")
f <- function(x, y) { ifelse(y>4, 0, x*y*exp(-(x+y))) }
z <- outer(x, y, f)
persp(x, y, z, theta = 150, phi = 20, r=10, shade=0.1,
            xlab="x", ylab="y", zlab="f(x,y)")

f     <- function(x, y) { x*y*exp(-(x+y)) }
x  <- seq(0, 7, by=0.2)
y  <- seq(0, 7, by=0.2)
z <- outer(x, y, f)

#########################################################################

                                                           #  figure 5.53
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
contour(x, y , z,  nlevels = 10, cex=2, las=1,
      xlim=c(0,6), ylim=c(0,6), xlab=" ", ylab=" ") 
     
 
#########################################################################

                           # function two-dimensional normal distribution
f     <- function(x, y, rho) {
  t.x   <- (x-m.x)/s.x;   t.y   <- (y-m.y)/s.y
  rho.h <- 1-rho^2
  (1/(2*pi*s.x*s.y*sqrt(rho.h))) * exp(-(1/(2*rho.h)) * 
                            ((t.x^2 - 2*rho*t.x*t.y + t.y^2))) 
}

m.x <- 0;  s.x <- 1
m.y <- 0;  s.y <- 1
rho <- 0

l.x <- m.x-2.5*s.x;    u.x <- m.x+2.5*s.x; x   <- seq(l.x, u.x, by=0.2)
l.y <- m.y-2.5*s.y;    u.y <- m.y+2.5*s.y; y   <- seq(l.y, u.y, by=0.2)

#########################################################################

                                                            # figure 5.54
par(mfrow=c(1,3), lwd=1.5, font.axis=2, bty="n", ps=15)
z <- outer(x, y, f, 0)
persp(x, y, z, theta = -30, phi = 20, r=4,
                      xlab="x", ylab="y", zlab="f(x,y)")
z <- outer(x, y, f, 0.5)
persp(x, y, z, theta = -30, phi = 20, r=4,
                      xlab="x", ylab="y", zlab="f(x,y)")
z <- outer(x, y, f, 0.9)
persp(x, y, z, theta = -30, phi = 20, r=4,
                      xlab="x", ylab="y", zlab="f(x,y)")

#########################################################################
 
l.x <- m.x-2.5*s.x;    u.x <- m.x+2.5*s.x
x   <- seq(l.x, u.x, by=0.15)
l.y <- m.y-2.5*s.y;    u.y <- m.y+2.5*s.y
y   <- seq(l.y, u.y, by=0.15)

                                                            # figure 5.55
par(mfrow=c(1,3), lwd=1.5, font.axis=2, bty="n", ps=15)
z <- outer(x, y, f, 0)
contour(x, y , z,  nlevels = 10, cex=2,
            xlim=c(-3,+3), ylim=c(-3,+3), xlab="x", ylab="y") 
z <- outer(x, y, f, 0.5)
contour(x, y , z,  nlevels = 10, cex=2,
            xlim=c(-3,+3), ylim=c(-3,+3), xlab="x", ylab="y") 
z <- outer(x, y, f, 0.9)
contour(x, y , z,  nlevels = 10, cex=2,
            xlim=c(-3,+3), ylim=c(-3,+3), xlab="x", ylab="y") 
   
# #######################################################################
